/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.regionalsettings;

import com.google.common.base.Strings;
import cz.insophy.inplan.util.Localizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"region"})
@XmlRootElement(name="regions", namespace="http://insophy.cz/schema/regional-settings")
public class XmlRegionalSettings {
    private static final Logger log = LoggerFactory.getLogger(XmlRegionalSettings.class);
    @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
    private List<Region> region;

    public List<Region> getRegion() {
        if (this.region == null) {
            this.region = new ArrayList<Region>();
        }
        return this.region;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"formatPattern", "decimalFormatSymbolsCfg", "firstDayOfWeek", "d3", "symbols", "dateParser", "timeParser"})
    @XmlRootElement(name="region", namespace="http://insophy.cz/schema/regional-settings")
    public static class Region {
        @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
        private List<FormatPattern> formatPattern;
        @XmlElement(name="decimalFormatSymbols", namespace="http://insophy.cz/schema/regional-settings", required=true)
        private DecimalFormatSymbolsCfg decimalFormatSymbolsCfg;
        @XmlElement(namespace="http://insophy.cz/schema/regional-settings")
        private FirstDayOfWeek firstDayOfWeek;
        @XmlElement(name="d3", namespace="http://insophy.cz/schema/regional-settings", required=true)
        private D3 d3;
        @XmlElement(name="symbols", namespace="http://insophy.cz/schema/regional-settings", required=true)
        private Symbols symbols;
        @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
        private DateParser dateParser;
        @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
        private TimeParser timeParser;
        @XmlAttribute(name="id", required=true)
        private String id;
        @XmlAttribute(name="baseLocale", required=true)
        private String baseLocale;
        @XmlTransient
        private Locale locale;
        @XmlTransient
        private DecimalFormatSymbols decimalFormatSymbols;

        public String getFormatPattern(FormatPattern.FormatType type) {
            return this.formatPattern.stream().filter(f -> f.getType() == type).findFirst().map(FormatPattern::getFormatPattern).orElseThrow(IllegalStateException::new);
        }

        public String getId() {
            return this.id;
        }

        public D3 getD3() {
            return this.d3;
        }

        public Symbols getSymbols() {
            return this.symbols;
        }

        public DateParser getDateParser() {
            return this.dateParser;
        }

        public TimeParser getTimeParser() {
            return this.timeParser;
        }

        private DecimalFormatSymbols getDecimalFormatSymbols() {
            if (this.decimalFormatSymbols == null) {
                Locale locale = this.getLocale();
                this.decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
                if (this.decimalFormatSymbolsCfg != null) {
                    if (!Strings.isNullOrEmpty(this.decimalFormatSymbolsCfg.getDecimalSeparator())) {
                        this.decimalFormatSymbols.setDecimalSeparator(this.decimalFormatSymbolsCfg.getDecimalSeparator().charAt(0));
                    }
                    if (!Strings.isNullOrEmpty(this.decimalFormatSymbolsCfg.getGroupingSeparator())) {
                        this.decimalFormatSymbols.setGroupingSeparator(this.decimalFormatSymbolsCfg.getGroupingSeparator().charAt(0));
                    }
                }
            }
            return this.decimalFormatSymbols;
        }

        public char getDecimalSeparator() {
            return this.getDecimalFormatSymbols().getDecimalSeparator();
        }

        public boolean useGrouping() {
            return !Strings.isNullOrEmpty(this.decimalFormatSymbolsCfg.getGroupingSeparator());
        }

        public FirstDayOfWeek getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        @Nonnull
        public Locale getLocale() {
            if (this.locale == null) {
                this.locale = Localizer.Language.localeFromString(this.baseLocale);
                if (Arrays.stream(Locale.getAvailableLocales()).filter(existingLocale -> this.locale.equals(existingLocale)).findFirst().isEmpty()) {
                    log.error("Region baeLocale='{}' does not exist. Default '{}' locale will be used.", (Object)this.baseLocale, (Object)Locale.getDefault());
                }
            }
            return this.locale;
        }

        public DecimalFormat createDecimalFormat(String pattern) {
            DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
            DecimalFormat decimalFormat = new DecimalFormat(pattern, decimalFormatSymbols);
            decimalFormat.setGroupingUsed(this.useGrouping());
            return decimalFormat;
        }

        public static class FormatPattern {
            @XmlValue
            private String formatPattern;
            @XmlAttribute(name="type")
            private FormatType type;

            public FormatPattern() {
            }

            public FormatPattern(String formatPattern, FormatType type) {
                this.formatPattern = formatPattern;
                this.type = type;
            }

            public String getFormatPattern() {
                return this.formatPattern;
            }

            public FormatType getType() {
                return this.type;
            }

            public static enum FormatType {
                SHORT_DATE,
                MEDIUM_DATE,
                LONG_DATE,
                SHORT_DATETIME,
                MEDIUM_DATETIME,
                LONG_DATETIME,
                TIME,
                FILE_DATE,
                NUMBER,
                PERCENT,
                NUMBER_DURATION;

            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"formatPattern"})
        @XmlRootElement(name="d3", namespace="http://insophy.cz/schema/regional-settings")
        public static class D3 {
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private List<FormatPattern> formatPattern;

            public FormatPattern getFormatPattern(@Nonnull FormatPattern.D3PatternType type) {
                return this.formatPattern.stream().filter(pattern -> type.equals((Object)pattern.getType())).findFirst().orElseThrow(IllegalStateException::new);
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="", propOrder={"pattern"})
            public static class FormatPattern {
                @XmlValue
                private String pattern;
                @XmlAttribute(name="type")
                private D3PatternType type;

                public FormatPattern() {
                }

                public FormatPattern(String pattern, D3PatternType type) {
                    this.pattern = pattern;
                    this.type = type;
                }

                public String getPattern() {
                    return this.pattern;
                }

                public D3PatternType getType() {
                    return this.type;
                }

                public static enum D3PatternType {
                    MILLISECOND("millisecond"),
                    SECOND("second"),
                    MINUTE("minute"),
                    HOUR("hour"),
                    DAY("day"),
                    WEEK("week"),
                    MONTH("month"),
                    YEAR("year");

                    private final String value;

                    private D3PatternType(String v) {
                        this.value = v;
                    }

                    public String value() {
                        return this.value;
                    }

                    public static D3PatternType fromValue(String v) {
                        for (D3PatternType c : D3PatternType.values()) {
                            if (!c.value.equals(v)) continue;
                            return c;
                        }
                        throw new IllegalArgumentException(v);
                    }
                }
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"undefined", "notANumber", "booleanTrue", "booleanFalse", "days", "hours", "minutes", "minutesShort", "seconds", "normoHour", "quantity"})
        @XmlRootElement(name="symbols", namespace="http://insophy.cz/schema/regional-settings")
        public static class Symbols {
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String undefined;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String notANumber;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String booleanTrue;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String booleanFalse;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String days;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String hours;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String minutes;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String minutesShort;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String seconds;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String normoHour;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private String quantity;

            public String getUndefined() {
                return this.undefined;
            }

            public String getNotANumber() {
                return this.notANumber;
            }

            public String getBooleanTrue() {
                return this.booleanTrue;
            }

            public String getBooleanFalse() {
                return this.booleanFalse;
            }

            public String getDays() {
                return this.days;
            }

            public String getHours() {
                return this.hours;
            }

            public String getMinutes() {
                return this.minutes;
            }

            public String getMinutesShort() {
                return this.minutesShort;
            }

            public String getSeconds() {
                return this.seconds;
            }

            public String getNormoHour() {
                return this.normoHour;
            }

            public String getQuantity() {
                return this.quantity;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"parsePattern"})
        @XmlRootElement(name="dateParser", namespace="http://insophy.cz/schema/regional-settings")
        public static class DateParser {
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private List<ParsePattern> parsePattern;

            public List<ParsePattern> getParsePattern() {
                if (this.parsePattern == null) {
                    this.parsePattern = new ArrayList<ParsePattern>();
                }
                return this.parsePattern;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="", propOrder={"pattern"})
            public static class ParsePattern {
                @XmlValue
                private String pattern;
                @XmlAttribute(name="duration")
                private DateDuration duration;

                public ParsePattern() {
                }

                public ParsePattern(String pattern, DateDuration duration) {
                    this.pattern = pattern;
                    this.duration = duration;
                }

                public String getPattern() {
                    return this.pattern;
                }

                public Period getDuration() {
                    return switch (this.duration) {
                        default -> throw new IncompatibleClassChangeError();
                        case DateDuration.ONE_DAY -> Period.ofDays(1);
                        case DateDuration.ONE_MONTH -> Period.ofMonths(1);
                    };
                }

                public static enum DateDuration {
                    ONE_DAY("oneDay"),
                    ONE_MONTH("oneMonth");

                    private final String value;

                    private DateDuration(String v) {
                        this.value = v;
                    }

                    public String value() {
                        return this.value;
                    }

                    public static DateDuration fromValue(String v) {
                        for (DateDuration c : DateDuration.values()) {
                            if (!c.value.equals(v)) continue;
                            return c;
                        }
                        throw new IllegalArgumentException(v);
                    }
                }
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"parsePattern"})
        @XmlRootElement(name="timeParser", namespace="http://insophy.cz/schema/regional-settings")
        public static class TimeParser {
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings", required=true)
            private List<ParsePattern> parsePattern;

            public List<ParsePattern> getParsePattern() {
                if (this.parsePattern == null) {
                    this.parsePattern = new ArrayList<ParsePattern>();
                }
                return this.parsePattern;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="", propOrder={"pattern"})
            public static class ParsePattern {
                @XmlValue
                private String pattern;
                @XmlAttribute(name="duration")
                private TimeDuration duration;

                public ParsePattern() {
                }

                public ParsePattern(String pattern, TimeDuration duration) {
                    this.pattern = pattern;
                    this.duration = duration;
                }

                public String getPattern() {
                    return this.pattern;
                }

                @Nonnull
                public Duration getDuration() {
                    return switch (this.duration) {
                        default -> throw new IncompatibleClassChangeError();
                        case TimeDuration.UNSET -> Duration.ZERO;
                        case TimeDuration.ONE_HOUR -> Duration.ofHours(1L);
                        case TimeDuration.ONE_MINUTE -> Duration.ofMinutes(1L);
                        case TimeDuration.ONE_SECOND -> Duration.ofSeconds(1L);
                    };
                }

                @XmlType(name="TimeDuration", namespace="http://insophy.cz/schema/regional-settings")
                public static enum TimeDuration {
                    UNSET("unset"),
                    ONE_SECOND("oneSecond"),
                    ONE_MINUTE("oneMinute"),
                    ONE_HOUR("oneHour");

                    private final String value;

                    private TimeDuration(String v) {
                        this.value = v;
                    }

                    public String value() {
                        return this.value;
                    }

                    public static TimeDuration fromValue(String v) {
                        for (TimeDuration c : TimeDuration.values()) {
                            if (!c.value.equals(v)) continue;
                            return c;
                        }
                        throw new IllegalArgumentException(v);
                    }
                }
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"decimalSeparator", "groupingSeparator"})
        @XmlRootElement(name="format", namespace="http://insophy.cz/schema/regional-settings")
        public static class DecimalFormatSymbolsCfg {
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings")
            private String decimalSeparator;
            @XmlElement(namespace="http://insophy.cz/schema/regional-settings")
            private String groupingSeparator;

            public String getDecimalSeparator() {
                return this.decimalSeparator;
            }

            public String getGroupingSeparator() {
                return this.groupingSeparator;
            }
        }

        @XmlType(name="FirstDayOfWeek", namespace="http://insophy.cz/schema/regional-settings")
        public static enum FirstDayOfWeek {
            SUNDAY("sunday"),
            MONDAY("monday");

            private final String value;

            private FirstDayOfWeek(String v) {
                this.value = v;
            }

            public String value() {
                return this.value;
            }

            public static FirstDayOfWeek fromValue(String v) {
                for (FirstDayOfWeek c : FirstDayOfWeek.values()) {
                    if (!c.value.equals(v)) continue;
                    return c;
                }
                throw new IllegalArgumentException(v);
            }
        }
    }
}

